function layout()
return {

forceFeedback = {
trimmer = 1.0,
shake = 0.5,
swapAxes = false,
},

keyCommands = {
-- Gameplay
{down = ICommandToggleConsole, name = 'Toggle Console', category = 'Debug'},
{down = iCommandQuit, name = 'End mission', category = 'General'},
{down = iCommandBrakeGo, name = 'Pause', category = 'General'},
{down = iCommandAccelerate, name = 'Time accelerate', category = 'General'},
{down = iCommandDecelerate, name = 'Time decelerate', category = 'General'},
{down = iCommandNoAcceleration, name = 'Time normal', category = 'General'},
{down = iCommandScoresWindowToggle, name = 'Score window', category = 'General'},
--{down = iCommandTrkEsc, name = 'Playback track cancel', category = 'General'},
--{down = iCommandRecordCursorOnOff, name = 'Record of mouse cursor in track On/Off', category = 'General'},
--{down = iCommandSoundMicOn, name = 'Sound recording begin', category = 'General'},
--{down = iCommandSoundMicOff, name = 'Sound recording end', category = 'General'},
--{down = iCommandTrackEditReplace, name = 'Track edit replace mode', category = 'General'},
--{down = iCommandTrackEditInsert, name = 'Track edit insert mode', category = 'General'},
{down = iCommandChat, name = 'Multiplayer chat - mode All', category = 'General'},
{down = iCommandFriendlyChat, name = 'Multiplayer chat - mode Allies', category = 'General'},
{down = iCommandInfoOnOff, name = 'Info bar view toggle', category = 'General'},
--{down = iCommandRecordSubtitleOn, name = 'Subtitle recording begin', category = 'General'},
--{down = iCommandRecordSubtitleOff, name = 'Subtitle recording end', category = 'General'},
{down = iCommandRecoverHuman, name = 'Get new plane - respawn', category = 'General'},
--{down = iCommandPlaneShipTakeOff, name = 'Ship Take Off Position', category = 'General'},
--{down = iCommandPlaneJump, name = 'Jump into other aircraft', category = 'General'},
{down = iCommandScreenShot, name = 'Screenshot', category = 'General'},
--{down = iCommandOneFrame, name = 'One frame mode', category = 'General'},
{down = iCommandGraphicsFrameRate, name = 'Frame rate counter - Service info', category = 'General'},
{down = iCommandViewCoordinatesInLinearUnits, name = 'Coordinates units change', category = 'General'},

--[[
--Flight Control
{down = iCommandPlaneUpStart, up = iCommandPlaneUpStop, name = 'Nose Down', category = 'Flight Control'},
{down = iCommandPlaneDownStart, up = iCommandPlaneDownStop, name = 'Nose Up', category = 'Flight Control'},
{down = iCommandPlaneLeftStart, up = iCommandPlaneLeftStop, name = 'Bank Left', category = 'Flight Control'},
{down = iCommandPlaneRightStart, up = iCommandPlaneRightStop, name = 'Bank Right', category = 'Flight Control'},
{down = iCommandPlaneLeftRudderStart, up = iCommandPlaneLeftRudderStop, name = 'Rudder Left', category = 'Flight Control'},
{down = iCommandPlaneRightRudderStart, up = iCommandPlaneRightRudderStop, name = 'Rudder Right', category = 'Flight Control'},

{down = iCommandPlaneUp, name = 'Plane Down', category = 'Flight Control'},
{down = iCommandPlaneDown, name = 'Plane Up', category = 'Flight Control'},
{down = iCommandPlaneLeft, name = 'Plane Left', category = 'Flight Control'},
{down = iCommandPlaneRight, name = 'Plane Right', category = 'Flight Control'},

{pressed = iCommandPlaneTrimUp, up = iCommandPlaneTrimStop, name = 'Trim Up', category = 'Flight Control'},
{pressed = iCommandPlaneTrimDown, up = iCommandPlaneTrimStop, name = 'Trim Down', category = 'Flight Control'},
{pressed = iCommandPlaneTrimLeft, up = iCommandPlaneTrimStop, name = 'Trim Left', category = 'Flight Control'},
{pressed = iCommandPlaneTrimRight, up = iCommandPlaneTrimStop, name = 'Trim Right', category = 'Flight Control'},
{pressed = iCommandPlaneTrimLeftRudder, up = iCommandPlaneTrimStop, name = 'Trim Left Rudder', category = 'Flight Control'},
{pressed = iCommandPlaneTrimRightRudder, up = iCommandPlaneTrimStop, name = 'Trim Right Rudder', category = 'Flight Control'},
{down = iCommandPlaneTrimCancel, name = 'Reset Trimmers', category = 'Flight Control'},

{down = iCommandPlaneAUTIncrease, name = 'Power Up', category = 'Flight Control'},
{down = iCommandPlaneAUTDecrease, name = 'Power Down', category = 'Flight Control'},
{down = iCommandPlaneAUTIncreaseRegime, name = 'Thrust Up', category = 'Flight Control'},
{down = iCommandPlaneAUTDecreaseRegime, name = 'Thrust Down', category = 'Flight Control'},

{down = iCommandPlaneAUTIncreaseLeft, name = 'Power Up Left', category = 'Flight Control'},
{down = iCommandPlaneAUTDecreaseLeft, name = 'Power Down Left', category = 'Flight Control'},
{down = iCommandPlaneAUTIncreaseRegimeLeft, name = 'Thrust Up Left', category = 'Flight Control'},
{down = iCommandPlaneAUTDecreaseRegimeLeft, name = 'Thrust Down Left', category = 'Flight Control'},

{down = iCommandPlaneAUTIncreaseRight, name = 'Power Up Right', category = 'Flight Control'},
{down = iCommandPlaneAUTDecreaseRight, name = 'Power Down Right', category = 'Flight Control'},
{down = iCommandPlaneAUTIncreaseRegimeRight, name = 'Thrust Up Right', category = 'Flight Control'},
{down = iCommandPlaneAUTDecreaseRegimeRight, name = 'Thrust Down Right', category = 'Flight Control'},
{down = iCommandPlaneCobra, name = 'Execute Pugachev\'s Cobra', category = 'Flight Control'},

-- Autopilot
{down = iCommandPlaneAutopilot, name = 'Toggle Autopilot', category = 'Autopilot'},
{down = iCommandPlaneAUTOnOff, name = 'Toggle Autothrust', category = 'Autopilot'},
{down = iCommandPlaneSAUHBarometric, name = 'Autopilot - Barometric Altitude Hold', category = 'Autopilot'},
{down = iCommandPlaneAutopilotOverrideOn, up = iCommandPlaneAutopilotOverrideOff, name = 'Autopilot override (Su-25T)', category = 'Autopilot'},
{down = iCommandPlaneStabTangBank, name = 'Autopilot - Attitude Hold', category = 'Autopilot'},
{down = iCommandPlaneStabHbarBank, name = 'Autopilot - Altitude And Roll Hold', category = 'Autopilot'},
{down = iCommandPlaneStabHorizon,	name = 'Autopilot - Transition To Level Flight Control', category = 'Autopilot'},
{down = iCommandPlaneStabHbar, name = 'Autopilot - Barometric Altitude Hold', category = 'Autopilot'},
{down = iCommandPlaneStabHrad, name = 'Autopilot - Radar Altitude Hold', category = 'Autopilot'},
{down = iCommandPlaneRouteAutopilot, name = 'Autopilot - \'Route following\'', category = 'Autopilot'},
{down = iCommandPlaneStabCancel, name = 'Autopilot Disengage', category = 'Autopilot'},

-- Systems
{down = iCommandPlaneAirBrake, name = 'Toggle Airbrake', category = 'Systems'},
{down = iCommandPlaneAirBrakeOn, name = 'Airbrake Out', category = 'Systems'},
{down = iCommandPlaneAirBrakeOff, name = 'Airbrake In', category = 'Systems'},
{down = iCommandPlaneFuelOn, up = iCommandPlaneFuelOff, name = 'Begin Refuel', category = 'Systems'},
{down = iCommandPlaneAirRefuel, name = 'Toggle Refueling Boom', category = 'Systems'},
{down = iCommandPlaneJettisonFuelTanks, name = 'Jettison Fuel Tanks', category = 'Systems'},
{down = iCommandPlaneWingtipSmokeOnOff, name = 'Toggle Smoke', category = 'Systems'},
{down = iCommandPowerOnOff, name = 'Power Switch Su-25T', category = 'Systems'},
{down = iCommandPlaneCockpitIllumination, name = 'Cockpit Illumination', category = 'Systems'},
{down = iCommandPlaneLightsOnOff, name = 'Toggle Navigation lights', category = 'Systems'},
{down = iCommandPlaneHeadLightOnOff, name = 'Toggle Gear Light Near/Far/Off', category = 'Systems'},
{down = iCommandPlaneFlaps, name = 'Toggle Flaps Up/Down', category = 'Systems'},
{down = iCommandPlaneFlapsOn, name = 'Flaps Down To The Landing Position', category = 'Systems'},
{down = iCommandPlaneFlapsOff, name = 'Flaps Up', category = 'Systems'},
{down = iCommandPlaneGear, name = 'Toggle Landing Gear Up/Down', category = 'Systems'},
{down = iCommandPlaneGearUp, name = 'Toggle Landing Gear Up', category = 'Systems'},
{down = iCommandPlaneGearDown, name = 'Toggle Landing Gear Down', category = 'Systems'},
{down = iCommandPlaneWheelBrakeOn, up = iCommandPlaneWheelBrakeOff, name = 'Wheel Brake On', category = 'Systems'},
{down = iCommandPlaneHook, name = 'Toggle Arrestor Hook', category = 'Systems'},
{down = iCommandPlanePackWing, name = 'Toggle Folding Wings', category = 'Systems'},
{down = iCommandPlaneFonar, name = 'Canopy Open/Close', category = 'Systems'},
{down = iCommandPlaneParachute, name = 'Release Drogue Chute', category = 'Systems'},
{down = iCommandPlaneResetMasterWarning, name = 'Reset Current Audible Warning', category = 'Systems'},
{down = iCommandPlaneJettisonWeapons, name = 'Jettison Weapons', category = 'Systems'},
{down = iCommandPlaneEject, name = 'Eject', category = 'Systems'},
{down = iCommandFlightClockReset, name = 'Start/Stop/Reset Flight Clock', category = 'Systems'},
{pressed = iCommandAltimeterPressureIncrease,	up = iCommandAltimeterPressureStop, name = 'Altimeter Pressure Increase Su-25T', category = 'Systems'},
{pressed = iCommandAltimeterPressureDecrease, up = iCommandAltimeterPressureStop, name = 'Altimeter Pressure Decrease Su-25T', category = 'Systems'},
{down = iCommandEnginesStart, name = 'Engines Start', category = 'Systems'},
{down = iCommandEnginesStop, name = 'Engines Stop', category = 'Systems'},
{down = iCommandLeftEngineStart, name = 'Left Engine Start', category = 'Systems'},
{down = iCommandLeftEngineStop, name = 'Left Engine Stop', category = 'Systems'},
{down = iCommandRightEngineStart, name = 'Right Engine Start', category = 'Systems'},
{down = iCommandRightEngineStop, name = 'Right Engine Stop', category = 'Systems'},
{down = iCommandBrightnessILS, name = 'HUD Color', category = 'Systems'},

-- Modes
{down = iCommandPlaneChangeTarget, name = '(`) Select Next Waypoint, Airfield Or Target', category = 'Modes'},
{down = iCommandPlaneModeNAV, name = '(1) Navigation Modes', category = 'Modes'},
{down = iCommandPlaneModeBVR, name = '(2) Beyond Visual Range Mode', category = 'Modes'},
{down = iCommandPlaneModeVS, name = '(3) Close Air Combat Vertical Scan Mode', category = 'Modes'},
{down = iCommandPlaneModeBore, name = '(4) Close Air Combat Bore Mode', category = 'Modes'},
{down = iCommandPlaneModeHelmet, name = '(5) Close Air Combat HMD Helmet Mode', category = 'Modes'},
{down = iCommandPlaneModeFI0, name = '(6) Longitudinal Missile Aiming Mode', category = 'Modes'},
{down = iCommandPlaneModeGround, name = '(7) Air-To-Ground Mode', category = 'Modes'},
{down = iCommandPlaneModeGrid, name = '(8) Gunsight Grid Switch', category = 'Modes'},

-- Sensors
{combos = {{key = 'JOY_BTN3'}}, down = iCommandPlaneChangeLock, name = 'Lock Target', category = 'Sensors'},
{down = iCommandRefusalTWS, name = 'Unlock Target', category = 'Sensors'},
{down = iCommandPlaneRadarOnOff, name = 'Toggle Radar On/Off', category = 'Sensors'},
{down = iCommandPlaneRadarChangeMode, name = 'Change Radar Mode RWS/TWS', category = 'Sensors'},
{down = iCommandPlaneRadarCenter, name = 'Target Designator To Center', category = 'Sensors'},
{down = iCommandPlaneChangeRadarPRF, name = 'Change Radar Pulse Repeat Frequency ', category = 'Sensors'},
{down = iCommandPlaneEOSOnOff, name = 'Toggle Electro-Optical System On/Off', category = 'Sensors'},
{down = iCommandPlaneLaserRangerOnOff, name = 'Toggle Laser Ranger On/Off', category = 'Sensors'},
{down = iCommandPlaneNightTVOnOff, name = 'Toggle Night Channel (FLIR or LLTV) On/Off', category = 'Sensors'},
{pressed = iCommandPlaneRadarUp, up = iCommandPlaneRadarStop, name = 'Target Designator Up', category = 'Sensors'},
{pressed = iCommandPlaneRadarDown, up = iCommandPlaneRadarStop, name = 'Target Designator Down', category = 'Sensors'},
{pressed = iCommandPlaneRadarLeft, up = iCommandPlaneRadarStop, name = 'Target Designator Left', category = 'Sensors'},
{pressed = iCommandPlaneRadarRight, up = iCommandPlaneRadarStop, name = 'Target Designator Right', category = 'Sensors'},
{pressed = iCommandSelecterUp, up = iCommandSelecterStop, name = 'Scan Zone Up', category = 'Sensors'},
{pressed = iCommandSelecterDown, up = iCommandSelecterStop, name = 'Scan Zone Down', category = 'Sensors'},
{pressed = iCommandSelecterLeft, up = iCommandSelecterStop, name = 'Scan Zone Left', category = 'Sensors'},
{pressed = iCommandSelecterRight, up = iCommandSelecterStop, name = 'Scan Zone Right', category = 'Sensors'},
{down = iCommandPlaneZoomIn, name = 'Display Zoom In', category = 'Sensors'},
{down = iCommandPlaneZoomOut, name = 'Display Zoom Out', category = 'Sensors'},
{down = iCommandPlaneLaunchPermissionOverride, name = 'Launch Permission Override', category = 'Sensors'},
{down = iCommandDecreaseRadarScanArea, name = 'Decrease Radar Scan Limit', category = 'Sensors'},
{down = iCommandIncreaseRadarScanArea, name = 'Increase Radar Scan Limit', category = 'Sensors'},
{pressed = iCommandPlaneIncreaseBase_Distance, up = iCommandPlaneStopBase_Distance, name = 'Increase Target Specified Size', category = 'Sensors'},
{pressed = iCommandPlaneDecreaseBase_Distance, up = iCommandPlaneStopBase_Distance, name = 'Decrease Target Specified Size', category = 'Sensors'},
{down = iCommandChangeRWRMode, name = 'Change RWR/SPO Mode', category = 'Sensors'},
{down = iCommandPlaneThreatWarnSoundVolumeDown, name = 'RWR/SPO Sound Signals Volume Down', category = 'Sensors'},
{down = iCommandPlaneThreatWarnSoundVolumeUp, name = 'RWR/SPO Sound Signals Volume Up', category = 'Sensors'},

-- Weapons                                                                        
{combos = {{key = 'JOY_BTN1'}}, down = iCommandPlaneFire, up = iCommandPlaneFireOff, name = 'Fire', category = 'Weapons'},
{combos = {{key = 'JOY_BTN4'}}, down = iCommandPlaneChangeWeapon, name = 'Change Weapon', category = 'Weapons'},
{down = iCommandPlaneModeCannon, name = 'Toggle Cannon', category = 'Weapons'},
{down = iCommandPlaneSalvoOnOff, name = 'Toggle Salvo Mode', category = 'Weapons'},
{combos = {{key = 'JOY_BTN2'}}, down = iCommandPlanePickleOn,	up = iCommandPlanePickleOff, name = 'Release Weapon', category = 'Weapons'},
{down = iCommandChangeGunRateOfFire, name = 'Change The Cannon Rate Of Fire / Cut Of Burst', category = 'Weapons'},
{down = iCommandChangeRippleQuantity, name = 'Change Ripple Quantity (A10/SU25/SU25T)', category = 'Weapons'},
{down = iCommandChangeRippleInterval, name = 'Increase Ripple Interval (A10/SU25/SU25T)', category = 'Weapons'},
{down = iCommandChangeRippleIntervalDown, name = 'Decrease Ripple Interval (A10/SU25/SU25T)', category = 'Weapons'},
{down = iCommandChangeReleaseMode, name = 'Cycle PRS/SGL Release Submodes (A10)', category = 'Weapons'},

-- Countermeasures
{down = iCommandPlaneDropSnar, name = 'Continuously Dispense Chaff And Flares', category = 'Countermeasures'},
{down = iCommandPlaneDropSnarOnce, name = 'Dispense Chaff And Flares', category = 'Countermeasures'},
{down = iCommandPlaneDropFlareOnce, name = 'Dispense Flares', category = 'Countermeasures'},
{down = iCommandPlaneDropChaffOnce, name = 'Dispense Chaff', category = 'Countermeasures'},
{down = iCommandActiveJamming, name = 'Toggle ECM', category = 'Countermeasures'},
{down = iCommandActiveIRJamming, name = 'Toggle Active IR Jamming', category = 'Countermeasures'},

-- Communications
{down = iCommandPlaneDoAndHome, name = 'Dispatch wingmans - complete mission and RTB', category = 'Communications'},
{down = iCommandPlaneDoAndBack, name = 'Dispatch wingmans - complete mission and rejoin', category = 'Communications'},
{down = iCommandPlaneFormation, name = 'Toggle formation', category = 'Communications'},
{down = iCommandPlaneJoinUp, name = 'Join up formation', category = 'Communications'},
{down = iCommandPlaneAttackMyTarget, name = 'Attack my target', category = 'Communications'},
{down = iCommandPlaneCoverMySix, name = 'Cover me', category = 'Communications'},
{down = iCommandAWACSHomeBearing, name = 'Ask AWACS home airbase', category = 'Communications'},
{down = iCommandAWACSTankerBearing, name = 'Ask AWACS available tanker', category = 'Communications'},
]]
{down = iCommandToggleCommandMenu, name = 'Communication menu', category = 'Communications'},
{down = ICommandSwitchDialog, name = 'Switch dialog', category = 'Communications'},

-- View                                                    
{combos = {{key = 'JOY_BTN_POV1_L'}}, pressed = iCommandViewLeftSlow, up = iCommandViewStopSlow, name = 'View Left slow', category = 'View'},
{combos = {{key = 'JOY_BTN_POV1_R'}}, pressed = iCommandViewRightSlow, up = iCommandViewStopSlow, name = 'View Right slow', category = 'View'},
{combos = {{key = 'JOY_BTN_POV1_U'}}, pressed = iCommandViewUpSlow, up = iCommandViewStopSlow, name = 'View Up slow', category = 'View'},
{combos = {{key = 'JOY_BTN_POV1_D'}}, pressed = iCommandViewDownSlow, up = iCommandViewStopSlow, name = 'View Down slow', category = 'View'},
{combos = {{key = 'JOY_BTN_POV1_UR'}}, pressed = iCommandViewUpRightSlow, up = iCommandViewStopSlow, name = 'View Up Right slow', category = 'View'},
{combos = {{key = 'JOY_BTN_POV1_DR'}}, pressed = iCommandViewDownRightSlow, up = iCommandViewStopSlow, name = 'View Down Right slow', category = 'View'},
{combos = {{key = 'JOY_BTN_POV1_DL'}}, pressed = iCommandViewDownLeftSlow, up = iCommandViewStopSlow, name = 'View Down Left slow', category = 'View'},
{combos = {{key = 'JOY_BTN_POV1_UL'}}, pressed = iCommandViewUpLeftSlow, up = iCommandViewStopSlow, name = 'View Up Left slow', category = 'View'},
{combos = {{key = 'JOY_BTN5'}}, pressed = iCommandViewCenter, name = 'View Center', category = 'View'},

{pressed = iCommandViewUp, up = iCommandViewStop, name = 'View up', category = 'View'},
{pressed = iCommandViewDown, up = iCommandViewStop, name = 'View down', category = 'View'},
{pressed = iCommandViewLeft, up = iCommandViewStop, name = 'View left', category = 'View'},
{pressed = iCommandViewRight, up = iCommandViewStop, name = 'View right', category = 'View'},
{pressed = iCommandViewUpRight, up = iCommandViewStop, name = 'View up right', category = 'View'},
{pressed = iCommandViewDownRight, up = iCommandViewStop, name = 'View down right', category = 'View'},
{pressed = iCommandViewDownLeft, up = iCommandViewStop, name = 'View down left', category = 'View'},
{pressed = iCommandViewUpLeft, up = iCommandViewStop, name = 'View up left', category = 'View'},
{pressed = iCommandViewForwardSlow, up = iCommandViewForwardSlowStop, name = 'Zoom in slow', category = 'View'},
{pressed = iCommandViewBackSlow, up = iCommandViewBackSlowStop, name = 'Zoom out slow', category = 'View'},
{pressed = iCommandViewForward, up = iCommandViewForwardStop, name = 'Zoom in', category = 'View Cockpit'},
{pressed = iCommandViewBack, up = iCommandViewBackStop, name = 'Zoom out', category = 'View Cockpit'},

{down = iCommandViewAngleDefault, name = 'Zoom normal', category = 'View'},
{pressed = iCommandViewExternalZoomIn, up = iCommandViewExternalZoomInStop, name = 'Zoom external in', category = 'View'},
{pressed = iCommandViewExternalZoomOut, up = iCommandViewExternalZoomOutStop, name = 'Zoom external out', category = 'View'},
{down = iCommandViewExternalZoomDefault, name = 'Zoom external normal', category = 'View'},
{down = iCommandViewSpeedUp, name = 'F11 camera moving forward', category = 'View'},
{down = iCommandViewSlowDown, name = 'F11 camera moving backward', category = 'View'},

{down = iCommandViewCockpit, name = 'F1 Cockpit view', category = 'View'},
{down = iCommandNaturalViewCockpitIn, name = 'F1 Natural head movement view', category = 'View'},
{down = iCommandViewHUDOnlyOnOff, name = 'F1 HUD only view switch', category = 'View'},
{down = iCommandViewAir, name = 'F2 Aircraft view', category = 'View'},
{down = iCommandViewMe, name = 'F2 View own aircraft', category = 'View'},
{down = iCommandViewFromTo, name = 'F2 Toggle camera position', category = 'View'},
{down = iCommandViewLocal, name = 'F2 Toggle local camera control', category = 'View'},
{down = iCommandViewTower, name = 'F3 Fly-By view', category = 'View'},
{down = iCommandViewTowerJump, name = 'F3 Fly-By jump view', category = 'View'},
{down = iCommandViewRear, name = 'F4 Look back view', category = 'View'},
{down = iCommandViewChase, name = 'F4 Chase view', category = 'View'},
{down = iCommandViewFight, name = 'F5 nearest AC view', category = 'View'},
{down = iCommandViewFightGround, name = 'F5 Ground hostile view', category = 'View'},
{down = iCommandViewWeapons, name = 'F6 Released weapon view', category = 'View'},
{down = iCommandViewWeaponAndTarget, name = 'F6 Weapon to target view', category = 'View'},
{down = iCommandViewGround, name = 'F7 Ground unit view', category = 'View'},
{down = iCommandViewJFO, name = 'F7 Ground JFO/JTAC view', category = 'View'},
{down = iCommandViewTargets, name = 'F8 Target view', category = 'View'},
{down = iCommandViewTargetType, name = 'F8 Player targets/All targets filter', category = 'View'},
{down = iCommandViewNavy, name = 'F9 Ship view', category = 'View'},
{down = iCommandViewLndgOfficer, name = 'F9 Landing signal officer view', category = 'View'},
{down = iCommandViewAWACS, name = 'F10 Theater map view', category = 'View'},
{down = iCommandViewAWACSJump, name = 'F10 Jump to theater map view over current point', category = 'View'},
{down = iCommandViewFree, name = 'F11 Airport free camera', category = 'View'},
{down = iCommandViewFreeJump, name = 'F11 Jump to free camera', category = 'View'},
{down = iCommandViewStatic, name = 'F12 Static object view', category = 'View'},
{down = iCommandViewMirage, name = 'F12 Civil traffic view', category = 'View'},
{down = iCommandViewLocomotivesToggle, name = 'F12 Trains/cars toggle', category = 'View'},
{down = iCommandViewPitHeadOnOff, name = 'F1 Head shift movement on / off', category = 'View'},

--[[
-- Cockpit view

{down = iCommandViewTempCockpitOn, up = iCommandViewTempCockpitOff, name = 'Cockpit panel view in', category = 'View Cockpit'},
{down = iCommandViewTempCockpitToggle, name = 'Cockpit panel view toggle', category = 'View Cockpit'},
--// Save current cockpit camera angles for fast numpad jumps  
{down = iCommandViewSaveAngles, name = 'Save Cockpit Angles', category = 'View Cockpit'},


{down = iCommandViewFastKeyboard, name = 'Fast keyboard turn speed', category = 'View'},
{down = iCommandViewSlowKeyboard, name = 'Slow keyboard turn speed', category = 'View'},
{down = iCommandViewNormalKeyboard, name = 'Normal keyboard turn speed', category = 'View'},
{down =  iCommandViewFastMouse, name = 'Fast mouse turn speed', category = 'View'},
{down = iCommandViewSlowMouse, name = 'Slow mouse turn speed', category = 'View'},
{down = iCommandViewNormalMouse, name = 'Normal mouse turn speed', category = 'View'},


{down = iCommandViewCameraUp, up = iCommandViewCameraCenter, name = 'Camera view up', category = 'View Cockpit'},
{down = iCommandViewCameraDown, up = iCommandViewCameraCenter, name = 'Camera view down', category = 'View Cockpit'},
{down = iCommandViewCameraLeft, up = iCommandViewCameraCenter, name = 'Camera view left', category = 'View Cockpit'},
{down = iCommandViewCameraRight, up = iCommandViewCameraCenter, name = 'Camera view right', category = 'View Cockpit'},
{down = iCommandViewCameraUpLeft, up = iCommandViewCameraCenter, name = 'Camera view up-left', category = 'View Cockpit'},
{down = iCommandViewCameraDownLeft, up = iCommandViewCameraCenter, name = 'Camera view down-left', category = 'View Cockpit'},
{down = iCommandViewCameraUpRight, up = iCommandViewCameraCenter, name = 'Camera view up-right', category = 'View Cockpit'},
{down = iCommandViewCameraDownRight, up = iCommandViewCameraCenter, name = 'Camera view down-right', category = 'View Cockpit'},
{down = iCommandViewPanToggle, name = 'Camera pan mode toggle', category = 'View Cockpit'},

{down = iCommandViewCameraUpSlow, name = 'Camera view up slow', category = 'View Cockpit'},
{down = iCommandViewCameraDownSlow, name = 'Camera view down slow', category = 'View Cockpit'},
{down = iCommandViewCameraLeftSlow, name = 'Camera view left slow', category = 'View Cockpit'},
{down = iCommandViewCameraRightSlow, name = 'Camera view right slow', category = 'View Cockpit'},
{down = iCommandViewCameraUpLeftSlow, name = 'Camera view up-left slow', category = 'View Cockpit'},
{down = iCommandViewCameraDownLeftSlow, name = 'Camera view down-left slow', category = 'View Cockpit'},
{down = iCommandViewCameraDownRight, name = 'Camera view up-right slow', category = 'View Cockpit'},
{down = iCommandViewCameraUpRightSlow, name = 'Camera view down-right slow', category = 'View Cockpit'},
{down = iCommandViewCameraCenter, name = 'Center camera view', category = 'View Cockpit'},
{down = iCommandViewCameraReturn, name = 'Return camera', category = 'View Cockpit'},
{down = iCommandViewCameraBaseReturn, name = 'Return camera base', category = 'View Cockpit'},

{down = iCommandViewSnapView0,	up = iCommandViewSnapViewStop, name = 'Snap View 0', category = 'View Cockpit'},
{down = iCommandViewSnapView1,	up = iCommandViewSnapViewStop, name = 'Snap View 1', category = 'View Cockpit'},
{down = iCommandViewSnapView2,	up = iCommandViewSnapViewStop, name = 'Snap View 2', category = 'View Cockpit'},
{down = iCommandViewSnapView3,	up = iCommandViewSnapViewStop, name = 'Snap View 3', category = 'View Cockpit'},
{down = iCommandViewSnapView4,	up = iCommandViewSnapViewStop, name = 'Snap View 4', category = 'View Cockpit'},
{down = iCommandViewSnapView5,	up = iCommandViewSnapViewStop, name = 'Snap View 5', category = 'View Cockpit'},
{down = iCommandViewSnapView6,	up = iCommandViewSnapViewStop, name = 'Snap View 6', category = 'View Cockpit'},
{down = iCommandViewSnapView7,	up = iCommandViewSnapViewStop, name = 'Snap View 7', category = 'View Cockpit'},
{down = iCommandViewSnapView8,	up = iCommandViewSnapViewStop, name = 'Snap View 8', category = 'View Cockpit'},
{down = iCommandViewSnapView9,	up = iCommandViewSnapViewStop, name = 'Snap View 9', category = 'View Cockpit'},
]]

-- Extended view
{down = iCommandViewCameraJiggle, name = 'Camera jiggle toggle', category = 'View Extended'},
{down = iCommandViewKeepTerrain, name = 'Keep terrain camera altitude', category = 'View Extended'},
{down = iCommandViewFriends, name = 'View friends mode', category = 'View Extended'},
{down = iCommandViewEnemies, name = 'View enemies mode', category = 'View Extended'},
{down = iCommandViewAll, name = 'View all mode', category = 'View Extended'},
{down = iCommandViewPlus, name = 'Toggle tracking fire weapon', category = 'View Extended'},
{down = iCommandViewSwitchForward, name = 'Objects switching direction forward ', category = 'View Extended'},
{down = iCommandViewSwitchReverse, name = 'Objects switching direction reverse ', category = 'View Extended'},
{down = iCommandViewObjectIgnore, name = 'Object exclude ', category = 'View Extended'},
{down = iCommandViewObjectsAll, name = 'Objects all excluded - include', category = 'View Extended'},

-- Padlock
{down = iCommandViewLock, name = 'Lock view (cycle padlock)', category = 'View Padlock'},
{down = iCommandViewUnlock, name = 'Unlock view (stop padlock)', category = 'View Padlock'},
--{down = iCommandAllMissilePadlock, name = 'All missiles padlock', category = 'View Padlock'},
--{down = iCommandThreatMissilePadlock, name = 'Threat missile padlock', category = 'View Padlock'},
{down = iCommandViewTerrainLock, name = 'Lock terrain view', category = 'View Padlock'},

-- Labels
{down = iCommandMarkerState, name = 'All Labels', category = 'Labels'},
{down = iCommandMarkerStatePlane, name = 'Aircraft Labels', category = 'Labels'},
{down = iCommandMarkerStateRocket, name = 'Missile Labels', category = 'Labels'},
{down = iCommandMarkerStateShip, name = 'Vehicle & Ship Labels', category = 'Labels'},

--[[
-- Auto Lock On
{down = iCommandAutoLockOnNearestAircraft, name = 'Auto lock on nearest aircraft', category = 'Simplifications'},
{down = iCommandAutoLockOnCenterAircraft, name = 'Auto lock on center aircraft', category = 'Simplifications'},
{down = iCommandAutoLockOnNextAircraft, name = 'Auto lock on next aircraft', category = 'Simplifications'},
{down = iCommandAutoLockOnPreviousAircraft, name = 'Auto lock on previous aircraft', category = 'Simplifications'},
{down = iCommandAutoLockOnNearestSurfaceTarget, name = 'Auto lock on nearest surface target', category = 'Simplifications'},
{down = iCommandAutoLockOnCenterSurfaceTarget, name = 'Auto lock on center surface target', category = 'Simplifications'},
{down = iCommandAutoLockOnNextSurfaceTarget, name = 'Auto lock on next surface target', category = 'Simplifications'},
{down = iCommandAutoLockOnPreviousSurfaceTarget, name = 'Auto lock on previous surface target', category = 'Simplifications'},
--]]



--//      (  )
--//iCommandRollbackSave,	"Create rollback point",						1, CONTROL,	KEY_O,  CUSTOM_FOLDER,
--//     
--//iCommandRollBack,		"Return to previous rollback point",			1, ALT,		KEY_O,  CUSTOM_FOLDER,
--//     
--//iCommandRollForward,	"Jump to next rollback point",					1, SHIFT,	KEY_O,  CUSTOM_FOLDER,
--// /     


--{combos = {{key = 'C'}}, down = iCommandCockpitClickModeOnOff, name = 'Clickable Mouse Cockpit Mode On/Off', category = 'Flight Control'},
--//iCommandCockpitClickOn,			 "Clickable cockpit action on"        , 1, RWIN, 0,					Flight Control_FOLDER,		//      
--//iCommandCockpitClickOff,		 "Clickable cockpit action off"       , 0, RWIN, 0,					Flight Control_FOLDER ,   	//       
--//iCommandCockpitSecondClickOn,	 "Clickable cockpit action on(secondary)" , 1,  LWIN, 0,			Flight Control_FOLDER,		//      
--//iCommandCockpitSecondClickOff,	 "Clickable cockpit action off(secondary)", 0,  LWIN, 0,			Flight Control_FOLDER ,   	//       


-- //iCommandAutomaticSpinRecovery, "Toggle automatic spin recovery",        1, ALT,     KEY_P,  Flight Control_FOLDER,
-- //iCommandSpeedRetention,     "Toggle speed retention",                   1, ALT,     KEY_S,  Flight Control_FOLDER,
-- //iCommandEasyLanding,        "Toggle easy landing",                      1, ALT,     KEY_E,  Flight Control_FOLDER,

-- FAC
--{combos = {{key = 'B', reformers = {'LWin'}}}, down = iCommandViewBinocular, name = 'Binocular view toggle', category = 'FAC'},
--{combos = {{key = 'L', reformers = {'LWin'}}}, down = iCommandViewLaserOnOff, name = 'Binocular laser illumination toggle', category = 'FAC'},
--{combos = {{key = 'Z', reformers = {'LWin'}}}, down = iCommandViewIR, name = 'Binocular view IR mode', category = 'FAC'},
-- /*
-- iCommandViewRangeFinderOn,	"Binocular range-finder on",				1, RWIN, KEY_R,			VIEW_FOLDER,			
-- iCommandViewRangeFinderOff,	"Binocular range-finder off",				0, RWIN, KEY_R,			VIEW_FOLDER,			
-- */
--{combos = {{key = 'C', 'LWin'}}}, down = iCommandCompassRose, name = 'Cockpit compass rose', category = 'View'},


},
--[[
axisCommands = {

-- joystick axes 
{combos = {{key = 'JOY_X'}}, action = iCommandPlaneRoll, name = 'Roll'},
{combos = {{key = 'JOY_Y'}}, action = iCommandPlanePitch, name = 'Pitch'},
{combos = {{key = 'JOY_RZ'}}, action = iCommandPlaneRudder, name = 'Rudder'},
{combos = {{key = 'JOY_SLIDER1'}}, action = iCommandPlaneThrustCommon, name = 'Thrust'},

-- mouse axes
--{action = iCommandPlaneViewHorizontal, name = 'Horizontal View'},
--{action = iCommandPlaneViewVertical, name = 'Vertical View'},
--{action = iCommandPlaneZoomView, name = 'Zoom View'},

-- TrackIR axes
{action = iCommandViewVerticalAbs, name = 'Horizontal View'},
{action = iCommandViewHorizontalAbs, name = 'Vertical View'},

-- TrackIR axes
-- iCommandPlaneViewHorizontal, "Horizontal View", 0, 0, TRACKIR_AXIS(0), 0,
-- iCommandPlaneViewVertical,   "Vertical View",   0, 0, TRACKIR_AXIS(1), 0,
-- iCommandPlaneZoomView,       "Zoom View",       0, 0, TRACKIR_AXIS(2), 0,
-- iCommandViewRoll,			"Roll View",		0, 0, TRACKIR_AXIS(3), 0,
-- iCommandViewHorTrans,		"Horizontal View Translate", 0, 0, TRACKIR_AXIS(4), 0,
-- iCommandViewVertTrans,		"Vertical View Translate", 0, 0, TRACKIR_AXIS(5), 0,

},
]]
}
end
